<?php
session_start();
// Check if the user is a logged-in student
if (!isset($_SESSION['userRole']) || $_SESSION['userRole'] !== 'student') {
    header("Location: login.php");
    exit();
}
// Include database connection
include 'includes/conn.php';
// Get the user role from the session
$userRole = isset($_SESSION['jRole']) ? $_SESSION['jRole'] : null;

// Topnav greeting
date_default_timezone_set("Asia/Kolkata");
$hour = date("H");

if ($hour >= 5 && $hour < 12) {
    $greeting = "Good Morning";
} elseif ($hour >= 12 && $hour < 18) {
    $greeting = "Good Afternoon";
} else {
    $greeting = "Good Evening";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Student Dashboard</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background-color: #f0f2f5; /* Light gray background for a modern feel */
            margin: 0;
        }

        /* Top Navigation Bar Styles */
        .topnav-custom {
            background-color: #ffffff;
            border-bottom: 1px solid #e0e6ed;
            box-shadow: 0 2px 5px rgba(0, 0, 0, 0.05);
        }
        .topnav-brand {
            font-weight: 700;
            color: #4a5568;
            font-size: 1.25rem;
        }
        .topnav-greeting {
            color: #a0a0a0;
            font-weight: 500;
        }
        .topnav-greeting span {
            color: #2d3748;
            font-weight: 700;
        }
        .topnav-user-icon {
            color: #4a5568;
        }
        .topnav-dropdown-item:hover {
            background-color: #f7fafc;
        }

        /* Side Navigation Bar Styles */
        .sidebar-wrapper {
            background-color: #2d3748; /* Dark, professional charcoal */
            color: #e2e8f0;
            height: 100vh;
            position: fixed;
            top: 0;
            left: 0;
            width: 250px;
            transition: transform 0.3s ease-in-out;
            box-shadow: 2px 0 10px rgba(0, 0, 0, 0.3);
            z-index: 1000;
            overflow-y: auto;
        }
        .sidebar-wrapper.collapsed {
            transform: translateX(-250px);
        }
        .sidebar-header {
            padding: 1.5rem 1rem;
            text-align: center;
        }
        .sidebar-brand {
            font-size: 1.5rem;
            font-weight: 800;
            color: #63b3ed; /* Vibrant blue for the brand */
        }
        .sidebar-menu-heading {
            color: #a0a0a0;
            font-size: 0.8rem;
            text-transform: uppercase;
            padding: 1rem 1.5rem 0.5rem;
        }
        .sidebar-nav-link {
            color: #e2e8f0;
            padding: 0.75rem 1.5rem;
            display: block;
            text-decoration: none;
            transition: background-color 0.2s ease, border-left 0.2s ease;
            border-left: 4px solid transparent;
        }
        .sidebar-nav-link:hover {
            background-color: #4a5568;
            color: #ffffff;
            border-left-color: #63b3ed;
        }
        .sidebar-nav-link.active {
            background-color: #63b3ed;
            color: #ffffff;
            font-weight: bold;
            border-left-color: #63b3ed;
        }
        .sidebar-nav-icon {
            width: 1.5rem;
            text-align: center;
            margin-right: 0.75rem;
        }
        .sidebar-footer {
            background-color: #2d3748;
            padding: 1rem;
            text-align: center;
            border-top: 1px solid rgba(255, 255, 255, 0.1);
        }
        .sidebar-footer .jobrole {
            font-weight: bold;
            text-transform: uppercase;
            color: #63b3ed;
        }

        /* Main Content and Dashboard Styles */
        .content-wrapper {
            margin-left: 250px;
            padding: 2rem;
            transition: margin-left 0.3s ease-in-out;
        }
        .content-wrapper.collapsed {
            margin-left: 0;
        }
        .card {
            background: #ffffff;
            border-radius: 12px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }
        .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        .profile-pic {
            width: 90px;
            height: 90px;
            object-fit: cover;
            border: 3px solid #63b3ed;
        }
        .video-player {
            border-radius: 10px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2);
        }
        .table-responsive {
            border-radius: 8px;
            overflow: hidden;
        }

        /* Mobile Responsiveness */
        @media (max-width: 991.98px) {
            .sidebar-wrapper {
                transform: translateX(-250px);
            }
            .sidebar-wrapper.show {
                transform: translateX(0);
            }
            .content-wrapper {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <nav class="sb-topnav navbar navbar-expand topnav-custom sticky-top">
        <a class="navbar-brand ps-3 topnav-brand" href="index.html">AVEnglishAcademy</a>
        <button class="btn btn-link btn-sm order-1 order-lg-0 me-4 me-lg-0" id="sidebarToggle"><i class="fas fa-bars topnav-user-icon"></i></button>
        
        <div class="d-none d-md-inline-block form-inline ms-auto me-0 me-md-3 my-2 my-md-0">
            <span class="topnav-greeting"><?= $greeting ?>, <span class="fw-bold"><?= $_SESSION['sfname']." ".$_SESSION['slname'] ?></span></span>
        </div>
        
        <ul class="navbar-nav ms-auto ms-md-0 me-3 me-lg-4">
            <li class="nav-item dropdown">
                <a class="nav-link dropdown-toggle" id="navbarDropdown" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false"><i class="fas fa-user-circle fa-fw topnav-user-icon"></i></a>
                <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="navbarDropdown">
                    <li><a class="dropdown-item topnav-dropdown-item" href="#!">Settings</a></li>
                    <li><a class="dropdown-item topnav-dropdown-item" href="#!">Activity Log</a></li>
                    <li><hr class="dropdown-divider" /></li>
                    <li><a class="dropdown-item topnav-dropdown-item" href="controller/logout.php">Logout</a></li>
                </ul>
            </li>
        </ul>
    </nav>

    <div id="layoutSidenav">
        <div id="layoutSidenav_nav" class="sidebar-wrapper">
            <nav class="sb-sidenav accordion" id="sidenavAccordion">
                <div class="sb-sidenav-menu">
                    <div class="nav">
                        <!-- <div class="sb-sidenav-menu-heading">Core</div> -->
                        <a class="nav-link sidebar-nav-link" href="#" data-tab="dashboard">
                            <div class="sb-nav-link-icon"><i class="fas fa-tachometer-alt"></i></div>
                            Dashboard
                        </a>
                        <div class="sb-sidenav-menu-heading">Student</div>
                        <a class="nav-link sidebar-nav-link" href="#" data-tab="courses">
                            <div class="sb-nav-link-icon"><i class="fa-solid fa-book-open"></i></div>
                            My Courses
                        </a>
                        <a class="nav-link sidebar-nav-link" href="#" data-tab="profile">
                            <div class="sb-nav-link-icon"><i class="fa-solid fa-user"></i></div>
                            Profile
                        </a>
                        <a class="nav-link sidebar-nav-link" href="#" data-tab="forum">
                            <div class="sb-nav-link-icon"><i class="fas fa-comments"></i></div>
                            Community Forum
                        </a>
                        <a class="nav-link sidebar-nav-link" href="#" data-tab="settings">
                            <div class="sb-nav-link-icon"><i class="fas fa-cog"></i></div>
                            Settings
                        </a>
                        
                        <?php if ($userRole === 'admin'): ?>
                            <div class="sb-sidenav-menu-heading">Admin</div>
                            <a class="nav-link sidebar-nav-link" href="charts.html">
                                <div class="sb-nav-link-icon"><i class="fas fa-users-cog"></i></div>
                                Profiles
                            </a>
                            <a class="nav-link sidebar-nav-link" href="videos.php">
                                <div class="sb-nav-link-icon"><i class="fas fa-video"></i></div>
                                Videos
                            </a>
                            <a class="nav-link sidebar-nav-link" href="student.php">
                                <div class="sb-nav-link-icon"><i class="fas fa-user-graduate"></i></div>
                                Students
                            </a>
                            <a class="nav-link sidebar-nav-link" href="subscription.php">
                                <div class="sb-nav-link-icon"><i class="fas fa-tags"></i></div>
                                Subscription
                            </a>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="sb-sidenav-footer sidebar-footer">
                    <div class="small">Logged in as:</div>
                    <div class="jobrole"><?= $_SESSION['jRole'] ?></div>
                </div>
            </nav>
        </div>

        <div class="content-wrapper">
            <main>
                <div class="container-fluid dashboard-container">
                    <div class="row">
                        <div class="col-lg-3 d-none d-lg-block">
                            <div class="card p-3 text-center mb-4">
                                <img id="userImage" alt="User Image" class="img-fluid rounded-circle profile-pic mx-auto mb-3" src="images/default_user.png">
                                <h5 class="fw-bold mb-0"><span id="studentName"></span></h5>
                                <p class="text-muted"><span id="studentGrade"></span></p>
                            </div>
                            <div class="card p-3">
                                <h5 class="fw-bold text-center mb-3"><i class="fas fa-bell me-2 text-warning"></i> Notifications</h5>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New video added to Science!</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>Your subscription expires in 3 days.</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New forum topic: "Ask the Instructor"</li>
                                </ul>
                            </div>
                        </div>

                        <div class="col-lg-6">
                            <div id="dashboard-content" class="tab-content">
                                <div class="tab-pane fade show active" id="dashboard-tab-pane">
                                    <div class="card p-4 mb-4">
                                        <h4 class="fw-bold text-center mb-3">My Learning Progress</h4>
                                        <div class="row text-center mb-4">
                                            <div class="col-6">
                                                <h5 class="mb-0 text-success fw-bold"><span id="completedCount">0</span></h5>
                                                <p class="text-muted">Completed</p>
                                            </div>
                                            <div class="col-6">
                                                <h5 class="mb-0 text-primary fw-bold"><span id="totalCount">0</span></h5>
                                                <p class="text-muted">Total Videos</p>
                                            </div>
                                        </div>
                                        <canvas id="progressChart"></canvas>
                                    </div>
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-3">Recently Watched</h4>
                                        <div id="videoPlayerContainer" class="ratio ratio-16x9 mb-4">
                                            <div class="bg-light d-flex align-items-center justify-content-center">
                                                <p class="text-muted">Select a video to play</p>
                                            </div>
                                        </div>
                                        <div class="table-responsive">
                                            <table id="purchasedVideosTbl" class="table table-hover" style="width:100%">
                                                <thead>
                                                    <tr>
                                                        <th>#</th>
                                                        <th>Main Title</th>
                                                        <th>Sub Title</th>
                                                        <th>Start Date</th>
                                                        <th>Expire Date</th>
                                                        <th>Status</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody></tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="courses-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">My Enrolled Courses</h4>
                                        <div id="coursesList" class="row">
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="forum-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Community Discussion</h4>
                                        <div class="alert alert-info" role="alert">
                                            This feature is under development. Coming soon!
                                        </div>
                                    </div>
                                </div>

                                <div class="tab-pane fade" id="settings-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Account Settings</h4>
                                        <div class="alert alert-info" role="alert">
                                            You can manage your profile, password, and notifications here.
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="profile-tab-pane">
                                    <div class="card p-4">
                                        <h4 class="fw-bold text-center mb-4">Your Profile</h4>
                                        <div class="alert alert-info" role="alert">
                                            Profile information will be displayed here.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-lg-3 d-none d-lg-block">
                            <div class="card p-3">
                                <h5 class="fw-bold text-center mb-3"><i class="fas fa-bell me-2 text-warning"></i> Notifications</h5>
                                <ul class="list-group list-group-flush">
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New video added to Science!</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>Your subscription expires in 3 days.</li>
                                    <li class="list-group-item"><i class="fas fa-circle text-primary me-2" style="font-size: 8px;"></i>New forum topic: "Ask the Instructor"</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.7/js/jquery.dataTables.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Sidebar toggle logic
            const sidebarToggle = document.getElementById('sidebarToggle');
            const sidebar = document.getElementById('layoutSidenav_nav');
            const content = document.querySelector('.content-wrapper');

            sidebarToggle.addEventListener('click', function(event) {
                event.preventDefault();
                sidebar.classList.toggle('collapsed');
                content.classList.toggle('collapsed');
            });

            // Function to set active link
            function setActiveLink(tabName) {
                document.querySelectorAll('.sidebar-nav-link').forEach(link => {
                    link.classList.remove('active');
                    if (link.getAttribute('data-tab') === tabName) {
                        link.classList.add('active');
                    }
                });
            }

            // Tab switching logic
            const navLinks = document.querySelectorAll('.sidebar-nav-link');
            const tabs = document.querySelectorAll('.tab-pane');
            navLinks.forEach(link => {
                link.addEventListener('click', function(e) {
                    e.preventDefault();
                    const tabName = this.dataset.tab;
                    if (tabName) {
                        setActiveLink(tabName);
                        tabs.forEach(tab => tab.classList.remove('show', 'active'));
                        const targetTab = document.getElementById(tabName + '-tab-pane');
                        if (targetTab) {
                            targetTab.classList.add('show', 'active');
                        }
                    }
                });
            });

            // Set initial active link based on URL hash or default
            const initialTab = window.location.hash.substring(1) || 'dashboard';
            setActiveLink(initialTab);
            const initialTabPane = document.getElementById(initialTab + '-tab-pane');
            if (initialTabPane) {
                initialTabPane.classList.add('show', 'active');
            }

            // Fetch user data
            fetch('controller/getuserimage.php')
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        const userData = data.data;
                        const img = document.getElementById('userImage');
                        img.src = userData.Sprofilepic || 'images/default_user.png';
                        document.getElementById('studentName').innerText = `${userData.Sfname} ${userData.Slname}`;
                        document.getElementById('studentGrade').innerText = `Grade: ${userData.Sgrade}`;
                    }
                });

            let progressChart;
            function loadPurchasedVideos() {
                fetch('controller/getpurchasedvideos.php')
                    .then(response => response.json())
                    .then(data => {
                        const tableBody = document.querySelector('#purchasedVideosTbl tbody');
                        tableBody.innerHTML = '';
                        let completedVideos = 0;
                        const totalVideos = data.length;
                        
                        // Fake progress for demonstration
                        completedVideos = Math.floor(Math.random() * totalVideos);

                        data.forEach((row, index) => {
                            const isExpired = new Date(row.exDate) < new Date();
                            const status = isExpired ? 'Expired' : 'Active';
                            const statusColor = isExpired ? 'danger' : 'success';
                            const watchBtn = isExpired ? `<button class="btn btn-sm btn-outline-secondary" disabled>Expired</button>` : `<button class="btn btn-sm btn-outline-primary watch-btn" data-url="${row.videourl}" data-title="${row.maintitle}">Watch</button>`;
                            
                            const newRow = `
                                <tr>
                                    <td>${index + 1}</td>
                                    <td>${row.maintitle}</td>
                                    <td>${row.subtitle}</td>
                                    <td>${new Date(row.sDate).toLocaleDateString()}</td>
                                    <td>${new Date(row.exDate).toLocaleDateString()}</td>
                                    <td><span class="badge bg-${statusColor}">${status}</span></td>
                                    <td>${watchBtn}</td>
                                </tr>
                            `;
                            tableBody.innerHTML += newRow;
                        });

                        document.getElementById('totalCount').innerText = totalVideos;
                        document.getElementById('completedCount').innerText = completedVideos;

                        if (progressChart) progressChart.destroy();
                        const ctx = document.getElementById('progressChart').getContext('2d');
                        progressChart = new Chart(ctx, {
                            type: 'doughnut',
                            data: {
                                labels: ['Completed', 'Pending'],
                                datasets: [{
                                    data: [completedVideos, totalVideos - completedVideos],
                                    backgroundColor: ['#63b3ed', '#e0e6ed'],
                                    hoverOffset: 4
                                }]
                            },
                            options: { responsive: true, cutout: '70%' }
                        });

                        if (!$.fn.DataTable.isDataTable('#purchasedVideosTbl')) {
                            $('#purchasedVideosTbl').DataTable({
                                paging: true,
                                scrollY: '300px',
                                scrollX: true,
                                scrollCollapse: true,
                                searching: true,
                                info: false,
                                destroy: true
                            });
                        } else {
                            $('#purchasedVideosTbl').DataTable().clear().rows.add($(tableBody).find('tr')).draw();
                        }
                    });
            }

            // Load video into player on click
            document.addEventListener('click', function(e) {
                if (e.target.classList.contains('watch-btn')) {
                    const videoUrl = e.target.dataset.url;
                    const videoTitle = e.target.dataset.title;
                    const videoPlayerContainer = document.getElementById('videoPlayerContainer');
                    videoPlayerContainer.innerHTML = `<iframe src="${videoUrl}" frameborder="0" allowfullscreen class="embed-responsive-item video-player"></iframe>`;
                }
            });

            // Initial load
            loadPurchasedVideos();
        });
    </script>
</body>
</html>